/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmplSet {
    private String _name;
    private int _type;
    private Object _valueList;
    private Object[] _valueArray;
    private int _rank;
    private int _valType;
    private int _count;

    private void setDefaults(String name) throws CmplException {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            throw new CmplException("Set name " + name + " contains whitespaces");
        }
        this._name = name;
        this._type = 0;
        this._rank = 1;
        this._valueList = null;
        this._count = -99;
    }

    public CmplSet(String name, int rank) throws CmplException {
        this.setDefaults(name);
        this._rank = rank;
    }

    public CmplSet(String name) throws CmplException {
        this.setDefaults(name);
    }

    public String name() {
        return this._name;
    }

    public int type() {
        return this._type;
    }

    public int rank() {
        return this._rank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int len() throws CmplException {
        if (this._count != -99) {
            return this._count;
        }
        this._count = 0;
        if (this._type == 0 || this._type == 1) {
            if (this._valType == 1) {
                this._count = ((ArrayList)this._valueList).size();
                return this._count;
            } else if (this._valueList instanceof int[]) {
                this._count = ((int[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof long[]) {
                this._count = ((long[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof Integer[]) {
                this._count = ((Integer[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof Long[]) {
                this._count = ((Long[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof String[]) {
                this._count = ((String[])this._valueList).length;
                return this._count;
            } else {
                if (!(this._valueList instanceof Object[])) throw new CmplException("set " + this._name + " containts data with unsupported data type" + this._valueList.getClass().toString());
                this._count = ((Object[])this._valueList).length;
            }
            return this._count;
        } else if (this._type == 2) {
            this._count = (Integer)this._valueArray[1] - (Integer)this._valueArray[0] + 1;
            return this._count;
        } else {
            if (this._type != 3) return this._count;
            this._count = (Integer)this._valueArray[1] > 0 ? (int)Math.ceil(Double.valueOf((Integer)this._valueArray[2] - (Integer)this._valueArray[0] + 1) / (double)Math.abs((Integer)this._valueArray[1])) : (int)Math.ceil(Double.valueOf((Integer)this._valueArray[0] - (Integer)this._valueArray[2] + 1) / (double)Math.abs((Integer)this._valueArray[1]));
        }
        return this._count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(int i) throws CmplException {
        if (this._type == 1) {
            throw new CmplException("CmplSet.get(int i) is not apllicable for tuple sets with rank>1 -> " + this._name);
        }
        Object tmpVal = null;
        boolean err = false;
        if (this._valType == 1) {
            if (i < ((ArrayList)this._valueList).size()) {
                tmpVal = ((ArrayList)this._valueList).get(i);
            } else {
                err = true;
            }
        } else if (this._valType == 2) {
            if (i < this._count) {
                if (this._valueList instanceof int[]) {
                    tmpVal = ((int[])this._valueList)[i];
                } else if (this._valueList instanceof long[]) {
                    tmpVal = ((long[])this._valueList)[i];
                } else if (this._valueList instanceof Integer[]) {
                    tmpVal = ((Integer[])this._valueList)[i];
                } else if (this._valueList instanceof Long[]) {
                    tmpVal = ((Long[])this._valueList)[i];
                } else {
                    if (!(this._valueList instanceof String[])) throw new CmplException("unsupported data type for the set: " + this._name);
                    tmpVal = ((String[])this._valueList)[i];
                }
            } else {
                err = true;
            }
        } else if (this._valType == 3) {
            if (i < this._valueArray.length) {
                tmpVal = this._valueArray[i];
            } else {
                err = true;
            }
        }
        if (!err) return tmpVal;
        throw new CmplException("Index out of range for set " + this._name);
    }

    public Object get(int i, int j) throws CmplException {
        if (this._type != 1) {
            throw new CmplException("CmplSet.get(int i, int j) is only apllicable for tuple sets with rank>1 -> " + this._name);
        }
        Object tmpVal = null;
        boolean err = false;
        try {
            if (this._valType == 1) {
                if (i < ((ArrayList)this._valueList).size()) {
                    tmpVal = ((ArrayList)((ArrayList)this._valueList).get(i)).get(j);
                } else if (((ArrayList)this._valueList).get(i).getClass().isArray()) {
                    if (((ArrayList)this._valueList).get(i) instanceof int[]) {
                        tmpVal = ((int[])((ArrayList)this._valueList).get(i))[j];
                    } else if (((ArrayList)this._valueList).get(i) instanceof long[]) {
                        tmpVal = ((long[])((ArrayList)this._valueList).get(i))[j];
                    } else if (((ArrayList)this._valueList).get(i) instanceof Integer[]) {
                        tmpVal = ((Integer[])((ArrayList)this._valueList).get(i))[j];
                    } else if (((ArrayList)this._valueList).get(i) instanceof Long[]) {
                        tmpVal = ((Long[])((ArrayList)this._valueList).get(i))[j];
                    } else if (((ArrayList)this._valueList).get(i) instanceof String[]) {
                        tmpVal = ((String[])((ArrayList)this._valueList).get(i))[j];
                    }
                }
            } else if (this._valType == 2) {
                if (this._valueList instanceof int[][]) {
                    tmpVal = ((int[][])this._valueList)[i][j];
                } else if (this._valueList instanceof long[][]) {
                    tmpVal = ((long[][])this._valueList)[i][j];
                } else if (this._valueList instanceof Integer[][]) {
                    tmpVal = ((Integer[][])this._valueList)[i][j];
                } else if (this._valueList instanceof Long[][]) {
                    tmpVal = ((Long[][])this._valueList)[i][j];
                } else if (this._valueList instanceof String[][]) {
                    tmpVal = ((String[][])this._valueList)[i][j];
                }
            }
        }
        catch (Exception e) {
            throw new CmplException("Index out of range for set " + this._name);
        }
        return tmpVal;
    }

    public void setValues(Object val) throws CmplException {
        if (!val.getClass().toString().contains("List") && !val.getClass().isArray()) {
            throw new CmplException("Incompatible data - not a list or an array - for set :" + this._name);
        }
        if (val.getClass().toString().contains("List")) {
            this._valType = 1;
            this._type = ((ArrayList)val).get(0).getClass().toString().contains("List") || ((ArrayList)val).get(0).getClass().isArray() ? 1 : 0;
        } else if (val.getClass().isArray()) {
            this._valType = 2;
            if (val instanceof int[] || val instanceof long[] || val instanceof Integer[] || val instanceof Long[] || val instanceof String[]) {
                this._type = 0;
            } else if (val instanceof Object[]) {
                this._type = ((Object[])val)[0].getClass().isArray() || ((Object[])val)[0].getClass().toString().contains("List") ? 1 : 0;
            } else {
                throw new CmplException("Incompatible data for set :" + this._name);
            }
        }
        if (this._type == 0 && this._rank > 1) {
            throw new CmplException("incorrect definition of the tuple set: " + this._name);
        }
        this._valueList = val;
        this._count = -99;
        this.len();
    }

    public void setValues(int val1, int val2) throws CmplException {
        this._type = 2;
        this._rank = 1;
        if (val2 < val1) {
            throw new CmplException("unexpected values for set " + this._name + " : end value " + String.valueOf(val2) + " is less then start value " + String.valueOf(val1));
        }
        this._valueArray = new Object[2];
        this._valueArray[0] = val1;
        this._valueArray[1] = val2;
        this._valType = 3;
        this._count = -99;
        this.len();
    }

    public void setValues(int val1, int val2, int val3) throws CmplException {
        this._type = 3;
        this._rank = 1;
        if (val2 > 0) {
            if (val3 <= val1) {
                throw new CmplException("unexpected values for set " + this._name + " : end value " + String.valueOf(val3) + " is less than or equal to start value " + String.valueOf(val1) + " and the increment is positive " + String.valueOf(val2));
            }
        } else if (val2 < 0) {
            if (val1 <= val3) {
                throw new CmplException("unexpected values for set " + this._name + " : end value " + String.valueOf(val3) + " is greater than or equal to start value " + String.valueOf(val1) + " and the increment is negative " + String.valueOf(val2));
            }
        } else {
            throw new CmplException("unexpected values for the set " + this._name + " :  increment/decrement equals zero  ");
        }
        this._valueArray = new Object[3];
        this._valueArray[0] = val1;
        this._valueArray[1] = val2;
        this._valueArray[2] = val3;
        this._valType = 3;
        this._count = -99;
        this.len();
    }

    public int valType() {
        return this._valType;
    }

    public Object values() {
        ArrayList<Integer> valList;
        block7: {
            Integer i;
            valList = null;
            if (this._type == 0 || this._type == 1) {
                return this._valueList;
            }
            if (this._type == 2) {
                valList = new ArrayList<Integer>();
                i = (Integer)this._valueArray[0];
                while (i <= (Integer)this._valueArray[1]) {
                    valList.add(i);
                    Integer n = i;
                    i = i + 1;
                }
            }
            if (this._type != 3) break block7;
            valList = new ArrayList();
            if ((Integer)this._valueArray[1] > 0) {
                i = (Integer)this._valueArray[0];
                while (i <= (Integer)this._valueArray[2]) {
                    valList.add(i);
                    i = i + (Integer)this._valueArray[1];
                }
            } else {
                i = (Integer)this._valueArray[0];
                while (i >= (Integer)this._valueArray[2]) {
                    valList.add(i);
                    i = i + (Integer)this._valueArray[1];
                }
            }
        }
        return valList;
    }
}

