/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplSolElement;
import jCMPL.CmplSolution;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CmplSolutions {
    private long _nrOfVariables;
    private long _nrOfConstraints;
    private String _objectiveName;
    private String _objectiveSense;
    private int _nrOfSolutions;
    private String _solverName;
    private String _solverMsg;
    private String _varDisplayOptions;
    private String _conDisplayOptions;
    private String _asciiSolFile;
    private String _csvSolFile;
    private String _cmplSolFile;
    private ArrayList<CmplSolution> _solList;
    private String _solutionFile;
    private ArrayList<String> _solFileContent;
    private boolean _isIntegerProgram;

    public CmplSolutions(String solFile) {
        this.setDefaults();
        this._solutionFile = solFile;
    }

    public CmplSolutions() {
        this.setDefaults();
    }

    private void setDefaults() {
        this._nrOfVariables = 0L;
        this._nrOfConstraints = 0L;
        this._objectiveName = "";
        this._objectiveSense = "";
        this._nrOfSolutions = 0;
        this._solverName = "";
        this._solverMsg = "";
        this._varDisplayOptions = "";
        this._conDisplayOptions = "";
        this._asciiSolFile = "";
        this._csvSolFile = "";
        this._cmplSolFile = "";
        this._solList = new ArrayList();
        this._solutionFile = "";
        this._isIntegerProgram = false;
    }

    public long nrOfVariables() {
        return this._nrOfVariables;
    }

    public long nrOfConstraints() {
        return this._nrOfConstraints;
    }

    public String objectiveName() {
        return this._objectiveName;
    }

    public String objectiveSense() {
        return this._objectiveSense;
    }

    public int nrOfSolutions() {
        return this._nrOfSolutions;
    }

    public String solver() {
        return this._solverName;
    }

    public String solverMessage() {
        return this._solverMsg;
    }

    public String conDisplayOptions() {
        return this._conDisplayOptions;
    }

    public String varDisplayOptions() {
        return this._varDisplayOptions;
    }

    public String asciiSolFile() {
        return this._asciiSolFile;
    }

    public String csvSolFile() {
        return this._csvSolFile;
    }

    public String cmplSolFile() {
        return this._cmplSolFile;
    }

    public ArrayList<CmplSolution> solutions() {
        return this._solList;
    }

    public CmplSolution solution() {
        return this._solList.get(0);
    }

    public ArrayList<String> solFileContent() {
        return this._solFileContent;
    }

    public void delSolFileContent() {
        this._solFileContent.clear();
    }

    public boolean isIntegerProgram() {
        return this._isIntegerProgram;
    }

    private CmplSolElement readSolLine(String line) throws CmplException {
        ArrayList<String> tmpList = new ArrayList<String>();
        String patternStr = "\"([^\"]*)\"";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(line);
        String tmpStr = "";
        while (matcher.find()) {
            tmpList.add(matcher.group(1));
        }
        CmplSolElement x = new CmplSolElement();
        x.setIdx(CmplTools.xmlStrToInteger((String)tmpList.get(0)));
        x.setName((String)tmpList.get(1));
        x.setType((String)tmpList.get(2));
        if (line.contains("<constraint")) {
            x.setActivity(CmplTools.xmlStrToDouble((String)tmpList.get(3)));
        } else if (x.type().equals("I") || x.type().equals("B")) {
            x.setActivity(CmplTools.xmlStrToLong((String)tmpList.get(3)));
            this._isIntegerProgram = true;
        } else {
            x.setActivity(CmplTools.xmlStrToDouble((String)tmpList.get(3)));
        }
        tmpStr = ((String)tmpList.get(4)).toUpperCase().contains("INF") ? "-Infinity" : (String)tmpList.get(4);
        x.setLowerBound(CmplTools.xmlStrToDouble(tmpStr));
        tmpStr = ((String)tmpList.get(5)).toUpperCase().contains("INF") ? "Infinity" : (String)tmpList.get(5);
        x.setUpperBound(CmplTools.xmlStrToDouble(tmpStr));
        if (((String)tmpList.get(6)).equals("NaN")) {
            x.setMarginal(Double.NaN);
        } else {
            x.setMarginal(CmplTools.xmlStrToDouble((String)tmpList.get(6)));
        }
        return x;
    }

    protected void readSolution() throws CmplException {
        this.readSolution("");
    }

    protected void readSolution(String solStr) throws CmplException {
        if (solStr.isEmpty() && this._solutionFile.isEmpty()) {
            throw new CmplException("Solver failed or cannot be executed");
        }
        this._solList.clear();
        if (!this._solutionFile.isEmpty()) {
            String line = "";
            try {
                BufferedReader in = new BufferedReader(new FileReader(this._solutionFile));
                this._solFileContent = new ArrayList();
                while ((line = in.readLine()) != null) {
                    this._solFileContent.add(line);
                }
                in.close();
            }
            catch (IOException e) {
                throw new CmplException("Cannot read solution file :" + this._solutionFile + " ->" + e);
            }
        } else {
            this._solFileContent = new ArrayList<String>(Arrays.asList(solStr.split("\n")));
        }
        long lineNr = 1L;
        Boolean generalSection = false;
        Boolean solutionSection = false;
        Boolean varSection = false;
        Boolean conSection = false;
        CmplSolution s = null;
        for (String line : this._solFileContent) {
            if (lineNr == 1L) {
                if (!line.contains("<?xml version")) {
                    throw new CmplException("File " + this._solutionFile + " - is not a XML file!");
                }
                ++lineNr;
                continue;
            }
            if (lineNr == 2L) {
                if (!line.contains("<CmplSolutions")) {
                    throw new CmplException("Can't read cmplSolution file " + this._solutionFile + " - wrong file type!");
                }
                ++lineNr;
                continue;
            }
            if (line.contains("<general>")) {
                generalSection = true;
                solutionSection = false;
                continue;
            }
            if (line.contains("</general>")) {
                generalSection = false;
                continue;
            }
            if (line.contains("<solution")) {
                generalSection = false;
                solutionSection = true;
                ArrayList<String> tmpList = new ArrayList<String>();
                String patternStr = "\"([^\"]*)\"";
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    tmpList.add(matcher.group(1));
                }
                s = new CmplSolution();
                s.setIdx(CmplTools.xmlStrToInteger((String)tmpList.get(0)));
                s.setStatus((String)tmpList.get(1));
                s.setValue(CmplTools.xmlStrToDouble((String)tmpList.get(2)));
                continue;
            }
            if (line.contains("</solution")) {
                solutionSection = false;
                this._solList.add(s);
                continue;
            }
            if (generalSection.booleanValue()) {
                if (line.contains("<nrOfVariables")) {
                    this._nrOfVariables = CmplTools.xmlStrToLong(line, "<nrOfVariables>(.*)</nrOfVariables>");
                    continue;
                }
                if (line.contains("<nrOfConstraints")) {
                    this._nrOfConstraints = CmplTools.xmlStrToLong(line, "<nrOfConstraints>([^\"]*)</nrOfConstraints>");
                    continue;
                }
                if (line.contains("<objectiveName")) {
                    this._objectiveName = CmplTools.xmlStrToString(line, "<objectiveName>([^\"]*)</objectiveName>");
                    continue;
                }
                if (line.contains("<objectiveSense")) {
                    this._objectiveSense = CmplTools.xmlStrToString(line, "<objectiveSense>([^\"]*)</objectiveSense>");
                    continue;
                }
                if (line.contains("<nrOfSolutions")) {
                    this._nrOfSolutions = CmplTools.xmlStrToInteger(line, "<nrOfSolutions>([^\"]*)</nrOfSolutions>");
                    continue;
                }
                if (line.contains("<solverName")) {
                    this._solverName = CmplTools.xmlStrToString(line, "<solverName>([^\"]*)</solverName>");
                    continue;
                }
                if (line.contains("<solverMsg")) {
                    this._solverMsg = CmplTools.xmlStrToString(line, "<solverMsg>([^\"]*)</solverMsg>");
                    continue;
                }
                if (line.contains("<variablesDisplayOptions")) {
                    this._varDisplayOptions = CmplTools.xmlStrToString(line, "<variablesDisplayOptions>([^\"]*)</variablesDisplayOptions>");
                    continue;
                }
                if (line.contains("<constraintsDisplayOptions")) {
                    this._conDisplayOptions = CmplTools.xmlStrToString(line, "<constraintsDisplayOptions>([^\"]*)</constraintsDisplayOptions>");
                    continue;
                }
                if (line.contains("<asciiSolFile")) {
                    this._asciiSolFile = CmplTools.xmlStrToString(line, "<asciiSolFile>([^\"]*)</asciiSolFile>");
                    continue;
                }
                if (line.contains("<csvSolFile")) {
                    this._csvSolFile = CmplTools.xmlStrToString(line, "<csvSolFile>([^\"]*)</csvSolFile>");
                    continue;
                }
                if (line.contains("<cmplSolFile")) {
                    this._cmplSolFile = CmplTools.xmlStrToString(line, "<cmplSolFile>([^\"]*)</cmplSolFile>");
                    continue;
                }
            }
            if (!solutionSection.booleanValue()) continue;
            if (line.contains("<variables>")) {
                varSection = true;
                conSection = false;
                continue;
            }
            if (line.contains("</variables>")) {
                varSection = false;
                continue;
            }
            if (line.contains("<linearConstraints>")) {
                varSection = false;
                conSection = true;
                continue;
            }
            if (line.contains("</linearConstraints>")) {
                conSection = false;
                continue;
            }
            if (varSection.booleanValue() && line.contains("<variable")) {
                s.setVar(this.readSolLine(line));
            }
            if (!conSection.booleanValue() || !line.contains("<constraint")) continue;
            s.setCon(this.readSolLine(line));
        }
    }
}

