/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmplTools {
    static Integer xmlStrToInteger(String txt) throws CmplException {
        try {
            int val = Integer.parseInt(txt.trim());
            return val;
        }
        catch (NumberFormatException e) {
            throw new CmplException("Can't convert string " + txt + " to long.");
        }
    }

    static Integer xmlStrToInteger(String txt, String patternStr) throws CmplException {
        int val = 0;
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(txt);
        if (matcher.find()) {
            val = CmplTools.xmlStrToInteger(matcher.group(1));
        }
        return val;
    }

    static Long xmlStrToLong(String txt) throws CmplException {
        try {
            long val = Long.parseLong(txt.trim());
            return val;
        }
        catch (NumberFormatException e) {
            throw new CmplException("Can't convert string " + txt + " to long.");
        }
    }

    static Long xmlStrToLong(String txt, String patternStr) throws CmplException {
        long val = 0L;
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(txt);
        if (matcher.find()) {
            val = CmplTools.xmlStrToLong(matcher.group(1));
        }
        return val;
    }

    static Double xmlStrToDouble(String txt) throws CmplException {
        try {
            double val = Double.parseDouble(txt.trim());
            return val;
        }
        catch (NumberFormatException e) {
            throw new CmplException("Can't convert string " + txt + " to double.");
        }
    }

    static String xmlStrToString(String txt, String patternStr) {
        String tmpStr = "";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(txt);
        if (matcher.find()) {
            tmpStr = matcher.group(1);
        }
        return tmpStr;
    }

    static ArrayList<String> xmlStrToStringList(String txt, String patternString) {
        ArrayList<String> tmpList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(txt);
        while (matcher.find()) {
            tmpList.add(matcher.group(1));
        }
        return tmpList;
    }

    static void delTmpFile(String name) {
        File f;
        if (!name.isEmpty() && (f = new File(name)).exists()) {
            f.delete();
        }
    }

    static void writeAsciiFile(String name, String txt) throws CmplException {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(name));
            out.write(txt);
            out.close();
        }
        catch (IOException e) {
            throw new CmplException("IO error for file " + name + ": " + e);
        }
    }
}

