/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplInstance;
import jCMPL.CmplMessages;
import jCMPL.CmplMsg;
import jCMPL.CmplParameter;
import jCMPL.CmplSet;
import jCMPL.CmplSolArray;
import jCMPL.CmplSolElement;
import jCMPL.CmplSolution;
import jCMPL.CmplSolutions;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class Cmpl
extends Thread {
    public static final int COMPATIBILITY = 3;
    public static final int CMPL_UNKNOWN = 0;
    public static final int CMPL_OK = 1;
    public static final int CMPL_WARNINGS = 2;
    public static final int CMPL_FAILED = 3;
    public static final int SOLVER_OK = 4;
    public static final int SOLVER_FAILED = 5;
    public static final int CMPLSERVER_OK = 6;
    public static final int CMPLSERVER_ERROR = 7;
    public static final int CMPLSERVER_BUSY = 8;
    public static final int CMPLSERVER_CLEANED = 9;
    public static final int CMPLSERVER_WARNING = 10;
    public static final int PROBLEM_RUNNING = 11;
    public static final int PROBLEM_FINISHED = 12;
    public static final int PROBLEM_CANCELED = 13;
    public static final int PROBLEM_NOTRUNNING = 14;
    public static final int CMPLGRID_SCHEDULER_UNKNOWN = 15;
    public static final int CMPLGRID_SCHEDULER_OK = 16;
    public static final int CMPLGRID_SCHEDULER_ERROR = 17;
    public static final int CMPLGRID_SCHEDULER_BUSY = 18;
    public static final int CMPLGRID_SCHEDULER_SOLVER_NOT_AVAILABLE = 19;
    public static final int CMPLGRID_SCHEDULER_WARNING = 20;
    public static final int CMPLGRID_SCHEDULER_PROBLEM_DELETED = 21;
    public static final int CMPL_GRID = 22;
    public static final int STANDALONE_SERVER = 23;
    public static final int SERVER_UNKNOWN = 24;
    private Map<Integer, String> CMPL_STATUS_TXT = new HashMap<Integer, String>();
    private final int _compatibility;
    private String _cmplDataFile;
    private String _cmplMsgFile;
    private String _cmplSolFile;
    private String _cmplFile;
    private String _problem;
    private StringBuilder _cmplDataStr;
    private ArrayList<CmplSet> _setList;
    private ArrayList<CmplParameter> _parameterList;
    private HashMap<Integer, String> _optionsList;
    private CmplMessages _status;
    private CmplSolutions _solutions;
    private String _solutionString;
    private boolean _remoteMode;
    private int _remoteStatus;
    private String _jobId;
    private String _solver;
    private int _maxCmplServerTries;
    private int _maxCmplServerQueuingTime;
    private XmlRpcClient _cmplServer;
    private String _cmplUrl;
    private boolean _cmplServerRunning;
    private XmlRpcClient _cmplGridScheduler;
    private String _cmplGridSchedulerUrl;
    private int _serverMode;
    private Process _cmplProc;
    private long _refreshTime;
    private boolean _printOutput;
    private StringBuilder _outputString;
    private int _id;
    private String _outputLeadString;
    private final String _model;
    private boolean _isCleaned;
    private boolean _debug;
    private boolean _runCanceled;

    public Cmpl(String model) throws CmplException {
        this._compatibility = 3;
        this.CMPL_STATUS_TXT.put(0, "CMPL_UNKNOWN");
        this.CMPL_STATUS_TXT.put(1, "CMPL_OK");
        this.CMPL_STATUS_TXT.put(2, "CMPL_WARNINGS");
        this.CMPL_STATUS_TXT.put(3, "CMPL_FAILED");
        this.CMPL_STATUS_TXT.put(4, "SOLVER_OK");
        this.CMPL_STATUS_TXT.put(5, "SOLVER_FAILED");
        this.CMPL_STATUS_TXT.put(6, "CMPLSERVER_OK");
        this.CMPL_STATUS_TXT.put(7, "CMPLSERVER_ERROR");
        this.CMPL_STATUS_TXT.put(8, "CMPLSERVER_BUSY");
        this.CMPL_STATUS_TXT.put(9, "CMPLSERVER_CLEANED");
        this.CMPL_STATUS_TXT.put(10, "CMPLSERVER_WARNING");
        this.CMPL_STATUS_TXT.put(11, "PROBLEM_RUNNING");
        this.CMPL_STATUS_TXT.put(12, "PROBLEM_FINISHED");
        this.CMPL_STATUS_TXT.put(13, "PROBLEM_CANCELED");
        this.CMPL_STATUS_TXT.put(14, "PROBLEM_NOTRUNNING");
        this.CMPL_STATUS_TXT.put(15, "CMPLGRID_SCHEDULER_UNKNOWN");
        this.CMPL_STATUS_TXT.put(16, "CMPLGRID_SCHEDULER_OK");
        this.CMPL_STATUS_TXT.put(17, "CMPLGRID_SCHEDULER_ERROR");
        this.CMPL_STATUS_TXT.put(18, "CMPLGRID_SCHEDULER_BUSY");
        this.CMPL_STATUS_TXT.put(19, "CMPLGRID_SCHEDULER_SOLVER_NOT_AVAILABLE");
        this.CMPL_STATUS_TXT.put(20, "CMPLGRID_SCHEDULER_WARNING");
        this.CMPL_STATUS_TXT.put(21, "CMPLGRID_SCHEDULER_PROBLEM_DELETED");
        this.CMPL_STATUS_TXT.put(22, "CMPL_GRID");
        this.CMPL_STATUS_TXT.put(23, "STANDALONE_SERVER");
        this.CMPL_STATUS_TXT.put(24, "SERVER_UNKNOWN");
        this._problem = "";
        this._cmplFile = "";
        this._cmplDataFile = "";
        this._cmplMsgFile = "";
        this._cmplSolFile = "";
        this._cmplDataStr = new StringBuilder();
        this._setList = new ArrayList();
        this._parameterList = new ArrayList();
        this._optionsList = new HashMap();
        this._status = new CmplMessages();
        this._solutions = new CmplSolutions();
        this._solutionString = "";
        this._remoteMode = false;
        this._remoteStatus = 0;
        this._cmplUrl = "";
        this._cmplGridSchedulerUrl = "";
        this._cmplServerRunning = false;
        this._serverMode = 24;
        this._jobId = "";
        this._solver = "cbc";
        this._maxCmplServerTries = 10;
        this._maxCmplServerQueuingTime = 300;
        this._cmplServer = null;
        this._cmplServerRunning = false;
        this._cmplProc = null;
        this._refreshTime = 400L;
        this._printOutput = false;
        this._outputString = new StringBuilder();
        this._model = model;
        this._isCleaned = false;
        this._debug = false;
        Locale.setDefault(Locale.ENGLISH);
        this._id = -1;
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.cleanUp();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    public String model() {
        return this._model;
    }

    public String problem() {
        return this._problem;
    }

    public long refreshTime() {
        return this._refreshTime;
    }

    public String output() {
        return this._outputString.toString();
    }

    public ArrayList<CmplMsg> cmplMessages() {
        return this._status.cmplMessageList();
    }

    public ArrayList<CmplSolution> solutionPool() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solutions();
        }
        throw new CmplException("No solution found so far");
    }

    public CmplSolution solution() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solution();
        }
        throw new CmplException("No solution found so far");
    }

    public long nrOfVariables() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.nrOfVariables();
        }
        throw new CmplException("The model isn't generated yet.");
    }

    public long nrOfConstraints() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.nrOfConstraints();
        }
        throw new CmplException("The model isn't generated yet.");
    }

    public String objectiveName() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.objectiveName();
        }
        throw new CmplException("No solution found so far");
    }

    public String objectiveSense() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.objectiveSense();
        }
        throw new CmplException("No solution found so far");
    }

    public int nrOfSolutions() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.nrOfSolutions();
        }
        throw new CmplException("No solution found so far");
    }

    public String solver() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solver();
        }
        throw new CmplException("Since the model isn't solved the solver is not known.");
    }

    public String solverMessage() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solverMessage();
        }
        throw new CmplException("Since the model isn't solved the solver message is not known.");
    }

    public String varDisplayOptions() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.varDisplayOptions();
        }
        throw new CmplException("Since the model isn't solved this option isn't known.");
    }

    public String conDisplayOptions() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.conDisplayOptions();
        }
        throw new CmplException("Since the model isn't solved this option isn't known.");
    }

    public int cmplStatus() {
        if (this._remoteMode && this._remoteStatus != 0) {
            return this._remoteStatus;
        }
        return this._status.cmplStatus();
    }

    public String cmplStatusText() {
        int stat = 0;
        stat = this._remoteMode && this._remoteStatus != 0 ? this._remoteStatus : this._status.cmplStatus();
        return this.CMPL_STATUS_TXT.get(stat);
    }

    public int solverStatus() {
        if (this._solutions.nrOfSolutions() == 0) {
            return 5;
        }
        return 4;
    }

    public String solverStatusText() {
        if (this._solutions.nrOfSolutions() == 0) {
            return "SOLVER_FAILED";
        }
        return "SOLVER_OK";
    }

    public String cmplSolFile() {
        return this._solutions.cmplSolFile();
    }

    public String csvSolFile() {
        return this._solutions.csvSolFile();
    }

    public String asciiSolFile() {
        return this._solutions.asciiSolFile();
    }

    public String jobId() {
        return this._jobId;
    }

    public void setOutput(Boolean ok, String lStr) {
        this._printOutput = ok;
        if (!lStr.isEmpty()) {
            this._outputLeadString = lStr;
        }
    }

    public void setOutput(Boolean ok) {
        this.setOutput(ok, "");
    }

    public void setRefreshTime(long rTime) {
        this._refreshTime = rTime;
    }

    private void setSet(CmplSet set) throws CmplException {
        if (set.len() <= 0) {
            throw new CmplException("set " + set.name() + " contains no elements ");
        }
        this._setList.add(set);
    }

    public void setSets(CmplSet ... sets) throws CmplException {
        for (int i = 0; i < sets.length; ++i) {
            this.setSet(sets[i]);
        }
    }

    private void setParameter(CmplParameter param) throws CmplException {
        if (param.len() <= 0L) {
            throw new CmplException("set " + param.name() + " contains no elements ");
        }
        this._parameterList.add(param);
    }

    public void setParameters(CmplParameter ... params) throws CmplException {
        for (int i = 0; i < params.length; ++i) {
            this.setParameter(params[i]);
        }
    }

    public Integer setOption(String option) {
        Integer pos = this._optionsList.size();
        this._optionsList.put(pos, option);
        return pos;
    }

    public void delOption(Integer pos) throws CmplException {
        this._optionsList.remove(pos);
    }

    public void delOptions() {
        this._optionsList.clear();
    }

    public void setMaxServerQueuingTime(Integer qTime) {
        this._maxCmplServerQueuingTime = qTime;
    }

    public int maxServerQueuingTime() {
        return this._maxCmplServerQueuingTime;
    }

    public void setMaxServerTries(Integer tries) {
        this._maxCmplServerTries = tries;
    }

    public int maxServerTries() {
        return this._maxCmplServerTries;
    }

    public void debug(boolean x) {
        this._debug = x;
    }

    public Object getVarByName(String name) throws CmplException {
        return this.getVarByName(name, 0);
    }

    public Object getVarByName(String name, int solNr) throws CmplException {
        return this.getElementByName(name, this._solutions.solutions().get(solNr).variables());
    }

    public Object getConByName(String name) throws CmplException {
        return this.getConByName(name, 0);
    }

    public Object getConByName(String name, int solNr) throws CmplException {
        return this.getElementByName(name, this._solutions.solutions().get(solNr).constraints());
    }

    public void solve() throws CmplException {
        block36: {
            int Min = 100000;
            int Max = 999999;
            File ModelFile = new File(this._model);
            if (!ModelFile.exists()) {
                throw new CmplException("Cannot read CMPL file: " + this._model);
            }
            this._id = Min + (int)(Math.random() * (double)(Max - Min + 1));
            this._outputLeadString = ModelFile.getName().substring(0, ModelFile.getName().lastIndexOf(46)) + "> ";
            if (this._remoteMode) {
                if (!this._cmplServerRunning) {
                    throw new CmplException("Model is not connected to a CmplServer");
                }
                this._status = new CmplMessages();
                this._solutions = new CmplSolutions();
                int tries = 0;
                long startTime = 0L;
                while (true) {
                    this._isCleaned = false;
                    try {
                        if (this._remoteStatus == 9) {
                            this.connect(this._cmplUrl);
                        }
                        if (this._serverMode == 22 && this._remoteStatus == 7) {
                            this.connect(this._cmplUrl);
                        }
                        if (this._remoteStatus == 18) {
                            startTime = System.currentTimeMillis();
                            while (this._remoteStatus != 16) {
                                Thread.sleep(this._refreshTime);
                                this.knockScheduler();
                                if ((System.currentTimeMillis() - startTime) / 1000L < (long)this._maxCmplServerQueuingTime) continue;
                                this.cleanUp();
                                throw new CmplException("maximum CmplServer queuing time is exceeded.");
                            }
                        }
                        String instStr = this.send();
                        if (this._debug) {
                            String _instFile = this._problem + ".cinst";
                            CmplTools.writeAsciiFile(_instFile, instStr);
                        }
                        if (this._remoteStatus == 8) {
                            startTime = System.currentTimeMillis();
                        }
                        while (this._remoteStatus != 12) {
                            this.knock();
                            Thread.sleep(this._refreshTime);
                            if (this._remoteStatus != 8 || (System.currentTimeMillis() - startTime) / 1000L < (long)this._maxCmplServerQueuingTime) continue;
                            throw new CmplException("maximum CmplServer queuing time is exceeded.");
                        }
                        this.retrieve();
                        break block36;
                    }
                    catch (CmplException e) {
                        if (this._serverMode == 22 && this._remoteStatus == 7 && !this._cmplGridSchedulerUrl.isEmpty()) {
                            try {
                                this.cmplServerExecute("cmplServerFailed", new Object[]{this._cmplUrl});
                                this.handleOutput("CmplServer failed <" + this._cmplUrl + ">: Problem will be newly connected to CmplGridScheduler and commited to another CmplServer.");
                                this._cmplUrl = this._cmplGridSchedulerUrl;
                                this._cmplGridSchedulerUrl = "";
                                this._cmplGridScheduler = null;
                                this._cmplServer = null;
                                continue;
                            }
                            catch (CmplException ex) {
                                throw new CmplException("CmplGridScheduler failed: " + ex.msg());
                            }
                            if (++tries != this._maxCmplServerTries) continue;
                            throw new CmplException(e.msg());
                        }
                        throw new CmplException(e.msg());
                    }
                    catch (InterruptedException ex) {
                        throw new CmplException("Problem has been canceled by user.");
                    }
                    break;
                }
            }
            Properties prop = System.getProperties();
            String os = prop.getProperty("os.name");
            String cmplSuffix = "_cmpl__" + this._id;
            this._problem = this._model.substring(0, this._model.lastIndexOf("."));
            this._cmplFile = this._problem + cmplSuffix + ".cmpl";
            this._cmplDataFile = this._problem + cmplSuffix + ".cdat";
            this._cmplMsgFile = this._problem + cmplSuffix + ".cmsg";
            this._cmplSolFile = this._problem + cmplSuffix + ".csol";
            this.cmplDataElements();
            this._status = new CmplMessages(this._cmplMsgFile);
            this._solutions = new CmplSolutions(this._cmplSolFile);
            Path source = Paths.get(this._model, new String[0]);
            Path destination = Paths.get(this._cmplFile, new String[0]);
            try {
                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                Logger.getLogger(Cmpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            Object cmplBin = System.getenv("CMPLHOME");
            if (cmplBin == null) {
                throw new CmplException("Environment variable CMPLHOME is not defined. Cannot run Cmpl binary.");
            }
            cmplBin = os.contains("Windows") ? (String)cmplBin + "bin\\cmpl.exe" : (String)cmplBin + "bin/cmpl";
            File cmplBinFile = new File((String)cmplBin);
            if (cmplBinFile.exists() && cmplBinFile.canExecute()) {
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add((String)cmplBin);
                cmdList.add(this._cmplFile);
                cmdList.add("-solution");
                if (this._compatibility < 3) {
                    cmdList.add("-e");
                    cmdList.add(this._cmplMsgFile);
                }
                if (os.contains("Windows")) {
                    cmdList.add("-cmplJava");
                }
                if (!this._optionsList.isEmpty()) {
                    for (Map.Entry<Integer, String> o : this._optionsList.entrySet()) {
                        if (this._compatibility > 2) {
                            for (String e : o.getValue().split(" ")) {
                                cmdList.add(e);
                            }
                            continue;
                        }
                        cmdList.add("-headerOpt");
                        cmdList.add(o.getValue().replace(" ", "#"));
                    }
                }
                if (this._compatibility > 2) {
                    cmdList.add("-cmsg");
                    cmdList.add(this._cmplMsgFile);
                }
                try {
                    String line;
                    ProcessBuilder launcher = new ProcessBuilder(cmdList);
                    launcher.redirectErrorStream(true);
                    this._cmplProc = launcher.start();
                    BufferedReader output = new BufferedReader(new InputStreamReader(this._cmplProc.getInputStream()));
                    while ((line = output.readLine()) != null) {
                        this.handleOutput(line);
                    }
                    if (!this._runCanceled) {
                        this._cmplProc.waitFor();
                    }
                    output.close();
                }
                catch (IOException ex) {
                    throw new CmplException("Can't execute the CMPL binary : " + ex);
                }
                catch (InterruptedException ex) {
                    throw new CmplException("Internal error : " + ex);
                }
                if (this._cmplProc.exitValue() != 0) {
                    throw new CmplException(this._outputString.toString());
                }
                this._status.readCmplMessages();
                if (this._status.cmplStatus() == 3) {
                    throw new CmplException("Cmpl finished with errors", this._status.cmplMessageList());
                }
            } else {
                throw new CmplException("Cant't execute Cmpl binary: " + (String)cmplBin);
            }
            this._solutions.readSolution();
            this.cleanUp();
            this.cleanUp();
        }
    }

    @Override
    public void run() {
        try {
            this.solve();
        }
        catch (CmplException ex) {
            System.err.println(ex.msg());
        }
    }

    @Override
    public void interrupt() {
        this._runCanceled = true;
        this._cmplProc.destroy();
        try {
            this.cleanUp();
        }
        catch (CmplException ex) {
            System.err.println(ex.msg());
        }
    }

    public void connect(String cmplUrl) throws CmplException {
        this._cmplUrl = cmplUrl;
        this._remoteMode = true;
        File file = new File(this._model);
        Object[] ret = null;
        int tries = 0;
        if (this._remoteStatus != 0 && this._remoteStatus != 9 && this._serverMode != 22) {
            throw new CmplException("Problem is still connected with CMPLServer: at " + cmplUrl + " with jobId " + this._jobId);
        }
        while (true) {
            this._remoteMode = true;
            this._remoteStatus = 0;
            this._serverMode = 23;
            this._cmplServer = null;
            this._cmplUrl = cmplUrl;
            this._cmplGridSchedulerUrl = "";
            this._cmplGridScheduler = null;
            try {
                XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
                config.setServerURL(new URL(this._cmplUrl));
                this._cmplServer = new XmlRpcClient();
                this._cmplServer.setConfig((XmlRpcClientConfig)config);
                this.getSolver();
                ret = (Object[])this._cmplServer.execute("getJobId", new Object[]{file.getName(), this._solver, this._compatibility});
                this._remoteStatus = (Integer)ret[0];
                if (this._remoteStatus == 6 || this._remoteStatus == 16 || this._remoteStatus == 18) {
                    this._jobId = (String)ret[2];
                }
                if (this._remoteStatus == 6 || this._remoteStatus == 7) {
                    this._serverMode = 23;
                    break;
                }
                if (this._remoteStatus != 16 && this._remoteStatus != 17 && this._remoteStatus != 18) break;
                this._serverMode = 22;
                this.handleOutput("Connected with CmplGridScheduler at " + this._cmplUrl + " with jobId " + this._jobId);
                if (this._remoteStatus != 16) break;
                this.connectServerViaScheduler(ret[1].toString());
                this._serverMode = 22;
            }
            catch (Exception e) {
                ++tries;
                this._cmplServer = null;
                if (e.toString().contains("getJobId()")) {
                    throw new CmplException("Incompatible CmplServer - please install a newer CMPLServer");
                }
                if (this._remoteStatus != 0) {
                    if (tries != this._maxCmplServerTries) continue;
                    throw new CmplException("CmplServer error: " + e.toString());
                }
                throw new CmplException("CmplServer error: " + e.toString());
            }
            break;
        }
        if (this._remoteStatus == 7 || this._remoteStatus == 17) {
            this.cleanUp();
            throw new CmplException((String)ret[1]);
        }
        this._cmplServerRunning = true;
        if (this._serverMode != 22) {
            this.handleOutput("Connected with CmplServer at " + this._cmplUrl + " with jobId " + this._jobId + " >> maxServerTries <" + this._maxCmplServerTries + "> maxQueuingTime <" + this._maxCmplServerQueuingTime + ">");
        }
        if (this._remoteStatus == 18) {
            this.handleOutput((String)ret[1]);
        }
    }

    public void disconnect() throws CmplException {
        this.cleanUp();
        this._remoteStatus = 0;
        this._cmplServer = null;
        this._cmplUrl = "";
        this._remoteMode = false;
        this._serverMode = 23;
    }

    public String send() throws CmplException {
        String instStr;
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplServer");
            }
            if (this._remoteStatus == 9) {
                this.connect(this._cmplUrl);
            }
            this.knock();
            if (this._remoteStatus == 11) {
                throw new CmplException("Don't send the problem again before the CmplServer finished the previous one");
            }
            this._problem = this._model.substring(0, this._model.lastIndexOf(46));
            this.cmplDataElements();
            this._status = new CmplMessages();
            this._solutions = new CmplSolutions();
            CmplInstance cmplInstance = new CmplInstance();
            instStr = cmplInstance.cmplInstanceStr(this._model, this._optionsList, this._cmplDataStr.toString(), this._jobId);
            Object[] ret = this.cmplServerExecute("send", new Object[]{instStr});
            this._remoteStatus = (Integer)ret[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)ret[1]);
            }
        } else {
            throw new CmplException("Cmpl.send can only be used in remote mode");
        }
        return instStr;
    }

    public void knock() throws CmplException {
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplServer");
            }
            if (this._remoteStatus == 9) {
                throw new CmplException("Model was received and cleaned on the CmplServer");
            }
            if (this._remoteStatus != 13) {
                Object[] ret = this.cmplServerExecute("knock", new Object[]{this._jobId});
                this._remoteStatus = (Integer)ret[0];
                if (this._remoteStatus == 7 || this._remoteStatus == 3) {
                    this.cleanUp();
                    throw new CmplException((String)ret[1]);
                }
                this.handleOutput((String)ret[2]);
            }
        } else {
            throw new CmplException("Cmpl.knock can only be used in remote mode");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void retrieve() throws CmplException {
        if (!this._remoteMode) throw new CmplException("Cmpl.retrieve can only be used in remote mode");
        if (!this._cmplServerRunning) {
            throw new CmplException("Model is not connected to a CmplServer");
        }
        if (this._remoteStatus == 9) {
            throw new CmplException("Model was received and cleaned from the CmplServer");
        }
        if (this._remoteStatus == 0) {
            this.knock();
        }
        if (this._remoteStatus == 12) {
            Object[] ret = this.cmplServerExecute("getCmplMessages", new Object[]{this._jobId});
            this._remoteStatus = (Integer)ret[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)ret[1]);
            }
            this._status.readCmplMessages((String)ret[2]);
            if (this._status.cmplStatus() == 3) {
                this.cleanUp();
                throw new CmplException("Cmpl finished with errors", this._status.cmplMessageList());
            }
            ret = this.cmplServerExecute("getSolutions", new Object[]{this._jobId});
            this._remoteStatus = (Integer)ret[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)ret[1]);
            }
            this._solutionString = (String)ret[2];
            this._solutions.readSolution(this._solutionString);
        } else {
            if (this._remoteStatus != 13) throw new CmplException("Model is still running, cannot retrieve the solutions");
            throw new CmplException("Model has been canceled by user, cannot retrieve the solutions");
        }
        this.writeSolFiles();
        this.cleanUp();
    }

    public void cancel() throws CmplException {
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplServer");
            }
            if (this._remoteStatus == 9) {
                throw new CmplException("Model has been received and cleaned on the CmplServer");
            }
            if (this._remoteStatus != 13) {
                Object[] ret = this.cmplServerExecute("cancel", new Object[]{this._jobId});
                this._remoteStatus = (Integer)ret[0];
                if (this._remoteStatus == 7) {
                    this.cleanUp();
                    throw new CmplException((String)ret[1]);
                }
                ret = this.cmplServerExecute("removeProblem", new Object[]{this._jobId});
                this._remoteStatus = (Integer)ret[0];
                if (this._remoteStatus == 7) {
                    this.cleanUp();
                    throw new CmplException((String)ret[1]);
                }
                this._remoteStatus = 9;
            }
        } else {
            this.cleanUp();
        }
    }

    public void saveSolution() throws CmplException {
        this.saveSolution("");
    }

    /*
     * WARNING - void declaration
     */
    public void saveSolution(String solFileName) throws CmplException {
        Object solFile;
        if (this._solutions.nrOfSolutions() > 0) {
            solFile = solFileName.isEmpty() ? this._problem + ".csol" : solFileName;
            if (!this._remoteMode) {
                StringBuilder solStr = new StringBuilder();
                for (String string : this._solutions.solFileContent()) {
                    void var5_5;
                    if (string.contains("instanceName")) {
                        String string2 = "       <instanceName>" + this._model + "</instanceName>";
                    }
                    solStr.append((String)var5_5 + "\n");
                }
                this._solutionString = solStr.toString();
            }
        } else {
            throw new CmplException("No solution found so far");
        }
        this._solutions.delSolFileContent();
        CmplTools.writeAsciiFile((String)solFile, this._solutionString);
    }

    public void saveSolutionAscii() throws CmplException {
        this.saveSolutionAscii("");
    }

    public void saveSolutionAscii(String solFileName) throws CmplException {
        if (this._solutions.nrOfSolutions() <= 0) {
            throw new CmplException("No solution found so far");
        }
        Object solFile = solFileName.isEmpty() ? this._problem + ".sol" : solFileName;
        this.solutionReport((String)solFile);
    }

    public void solutionReport() throws CmplException {
        this.solutionReport("");
    }

    public void solutionReport(String fileName) throws CmplException {
        StringBuilder repStr = new StringBuilder();
        File file = new File(this._model);
        if (this._solutions.nrOfSolutions() > 0) {
            repStr.append("---------------------------------------------------------------------------------------------------------\n");
            repStr.append(String.format("%-20s %s%n", "Problem", file.getName()));
            repStr.append(String.format("%-20s %d%n", "Nr. of variables", this._solutions.nrOfVariables()));
            repStr.append(String.format("%-20s %d%n", "Nr. of constraints", this._solutions.nrOfConstraints()));
            repStr.append(String.format("%-20s %s%n", "Objective name", this._solutions.objectiveName()));
            if (this._solutions.nrOfSolutions() > 1) {
                repStr.append(String.format("%-20s %d%n", "Nr. of solutions", this._solutions.nrOfSolutions()));
            }
            repStr.append(String.format("%-20s %s%n", "Solver name", this._solutions.solver()));
            repStr.append(String.format("%-20s %s%n", "Display variables", this._solutions.varDisplayOptions()));
            repStr.append(String.format("%-20s %s%n", "Display vonstraints", this._solutions.conDisplayOptions()));
            repStr.append("---------------------------------------------------------------------------------------------------------\n");
            for (CmplSolution s : this._solutions.solutions()) {
                repStr.append("\n");
                if (this._solutions.nrOfSolutions() > 1) {
                    repStr.append(String.format("%-20s %d%n", "Solution nr.", s.idx()));
                }
                repStr.append(String.format("%-20s %s%n", "Objective status", s.status()));
                repStr.append(String.format("%-20s %-20.2f (%s!)%n", "Objective value", s.value(), this._solutions.objectiveSense()));
                repStr.append("\n");
                if (s.variables().size() > 0) {
                    repStr.append(String.format("%-20s%n", "Variables"));
                    repStr.append(String.format("%-20s%5s%20s%20s%20s%20s%n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                    repStr.append("---------------------------------------------------------------------------------------------------------\n");
                    for (CmplSolElement v : s.variables()) {
                        if (v.type().equals("C")) {
                            repStr.append(String.format("%-20s%5s%20.2f%20.2f%20.2f", v.name(), v.type(), (Double)v.activity(), v.lowerBound(), v.upperBound()));
                        } else {
                            repStr.append(String.format("%-20s%5s%20d%20.2f%20.2f", v.name(), v.type(), (Long)v.activity(), v.lowerBound(), v.upperBound()));
                        }
                        if (this._solutions.isIntegerProgram()) {
                            repStr.append(String.format("%20s%n", "-"));
                            continue;
                        }
                        repStr.append(String.format("%20.2f%n", v.marginal()));
                    }
                    repStr.append("---------------------------------------------------------------------------------------------------------\n");
                }
                if (s.constraints().size() <= 0) continue;
                repStr.append("\n");
                repStr.append(String.format("%-20s%n", "Constraints"));
                repStr.append(String.format("%-20s%5s%20s%20s%20s%20s%n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                repStr.append("---------------------------------------------------------------------------------------------------------\n");
                for (CmplSolElement c : s.constraints()) {
                    repStr.append(String.format("%-20s%5s%20.2f%20.2f%20.2f", c.name(), c.type(), c.activity(), c.lowerBound(), c.upperBound()));
                    if (this._solutions.isIntegerProgram()) {
                        repStr.append(String.format("%20s%n", "-"));
                        continue;
                    }
                    repStr.append(String.format("%20.2f%n", c.marginal()));
                }
                repStr.append("---------------------------------------------------------------------------------------------------------\n");
            }
            if (fileName.isEmpty()) {
                System.out.print(repStr);
            } else {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
                    out.write(repStr.toString());
                    out.close();
                }
                catch (IOException e) {
                    throw new CmplException("IO error for file " + fileName + ": " + e);
                }
            }
        } else {
            throw new CmplException("No solution found so far");
        }
    }

    public void saveSolutionCsv() throws CmplException {
        this.saveSolutionCsv("");
    }

    public void saveSolutionCsv(String solFileName) throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            Object solFile = solFileName.isEmpty() ? this._problem + ".csv" : solFileName;
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter((String)solFile));
                out.write("CMPL csv export\n");
                out.write("\n");
                out.write(String.format("%s;%s\n", "Problem", this._problem + ".cmpl"));
                out.write(String.format("%s;%d\n", "Nr. of variables", this._solutions.nrOfVariables()));
                out.write(String.format("%s;%d\n", "Nr. of constraints", this._solutions.nrOfConstraints()));
                out.write(String.format("%s;%s\n", "Objective name", this._solutions.objectiveName()));
                if (this._solutions.nrOfSolutions() > 1) {
                    out.write(String.format("%s;%d\n", "Nr. of solutions", this._solutions.nrOfSolutions()));
                }
                out.write(String.format("%s;%s\n", "Solver name", this._solutions.solver()));
                out.write(String.format("%s;%s\n", "Display variables", this._solutions.varDisplayOptions()));
                out.write(String.format("%s;%s\n", "Display constraints", this._solutions.conDisplayOptions()));
                for (CmplSolution s : this._solutions.solutions()) {
                    out.write("\n");
                    if (this._solutions.nrOfSolutions() > 1) {
                        out.write(String.format("%s;%d\n", "Solution Nr.", s.idx() + 1));
                    }
                    out.write(String.format("%s;%s\n", "Objective status", s.status()));
                    out.write(String.format("%s;%f;(%s!)\n", "Objective value", s.value(), this._solutions.objectiveSense()));
                    if (s.variables().size() > 0) {
                        out.write(String.format("%s\n", "Variables"));
                        out.write(String.format("%s;%s;%s;%s;%s;%s\n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                        for (CmplSolElement v : s.variables()) {
                            if (v.type().equals("C")) {
                                out.write(String.format("%s;%s;%f;%f;%f", v.name(), v.type(), (Double)v.activity(), v.lowerBound(), v.upperBound()));
                            } else {
                                out.write(String.format("%s;%s;%d;%f;%f", v.name(), v.type(), (Long)v.activity(), v.lowerBound(), v.upperBound()));
                            }
                            if (this._solutions.isIntegerProgram()) {
                                out.write(";-\n");
                                continue;
                            }
                            out.write(String.format(";%f\n", v.marginal()));
                        }
                    }
                    if (s.constraints().size() <= 0) continue;
                    out.write(String.format("%s\n", "Constraints"));
                    out.write(String.format("%s;%s;%s;%s;%s;%s\n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                    for (CmplSolElement c : s.constraints()) {
                        out.write(String.format("%s;%s;%f;%f;%f", c.name(), c.type(), c.activity(), c.lowerBound(), c.upperBound()));
                        if (this._solutions.isIntegerProgram()) {
                            out.write(";-\n");
                            continue;
                        }
                        out.write(String.format(";%f\n", c.marginal()));
                    }
                }
                out.close();
            }
            catch (Exception e) {
                throw new CmplException("IO error for file " + solFileName + ": " + e);
            }
        } else {
            throw new CmplException("No solution found so far");
        }
    }

    private void cleanUp() throws CmplException {
        if (!this._isCleaned) {
            if (this._debug) {
                try {
                    System.out.println("Hit Enter to exit");
                    System.in.read();
                }
                catch (IOException ex) {
                    throw new CmplException("Internal error: " + ex);
                }
            }
            if (this._remoteMode) {
                if (this._serverMode != 22 || this._cmplGridSchedulerUrl != "") {
                    if (this._remoteStatus != 12 && this._remoteStatus != 7 && this._remoteStatus != 13 && this._cmplServerRunning) {
                        this.cmplServerExecute("cancel", new Object[]{this._jobId});
                    }
                    if (this._remoteStatus != 9 && this._remoteStatus != 7) {
                        this.cmplServerExecute("removeProblem", new Object[]{this._jobId});
                        this._remoteStatus = 9;
                    }
                }
                if (this._serverMode == 22 && (this._remoteStatus == 18 || this._remoteStatus == 15)) {
                    this.cmplServerExecute("disconnectProblem", new Object[]{this._jobId});
                }
            } else {
                if (this._cmplProc != null) {
                    this._cmplProc.destroy();
                }
                CmplTools.delTmpFile(this._cmplDataFile);
            }
            CmplTools.delTmpFile(this._cmplMsgFile);
            CmplTools.delTmpFile(this._cmplSolFile);
            CmplTools.delTmpFile(this._cmplFile);
            this._isCleaned = true;
        }
    }

    private void cmplDataElements() throws CmplException {
        try {
            for (CmplSet s : this._setList) {
                int i;
                this._cmplDataStr.append("%");
                this._cmplDataStr.append(s.name());
                if (s.rank() > 1) {
                    this._cmplDataStr.append(" set[");
                    this._cmplDataStr.append(String.valueOf(s.rank()));
                    this._cmplDataStr.append("] < ");
                } else {
                    this._cmplDataStr.append(" set < ");
                }
                if (s.type() == 0) {
                    this._cmplDataStr.append("\n");
                    int count = 1;
                    for (i = 0; i < s.len(); ++i) {
                        this._cmplDataStr.append((CharSequence)this.writeElement(s.get(i)));
                        if (count == s.rank()) {
                            this._cmplDataStr.append("\n");
                            count = 1;
                            continue;
                        }
                        ++count;
                    }
                }
                if (s.type() == 1) {
                    this._cmplDataStr.append("\n");
                    for (i = 0; i < s.len(); ++i) {
                        for (int j = 0; j < s.rank(); ++j) {
                            this._cmplDataStr.append((CharSequence)this.writeElement(s.get(i, j)));
                        }
                        this._cmplDataStr.append("\n");
                    }
                }
                if (s.type() == 2) {
                    this._cmplDataStr.append(s.get(0));
                    this._cmplDataStr.append("..");
                    this._cmplDataStr.append(s.get(1));
                    this._cmplDataStr.append(" ");
                }
                if (s.type() == 3) {
                    this._cmplDataStr.append(s.get(0));
                    this._cmplDataStr.append("(");
                    this._cmplDataStr.append(s.get(1));
                    this._cmplDataStr.append(")");
                    this._cmplDataStr.append(s.get(2));
                    this._cmplDataStr.append(" ");
                }
                this._cmplDataStr.append(">\n");
            }
            for (CmplParameter p : this._parameterList) {
                this._cmplDataStr.append("%");
                this._cmplDataStr.append(p.name());
                int pos = 0;
                if (p.rank() > 0) {
                    this._cmplDataStr.append("[");
                    for (CmplSet s : p.setList()) {
                        boolean setFound = false;
                        for (CmplSet j : this._setList) {
                            if (!s.name().equals(j.name())) continue;
                            setFound = true;
                            break;
                        }
                        if (!setFound) {
                            throw new CmplException("The set " + s.name() + " used for the parameter " + p.name() + " doesn't exist.");
                        }
                        this._cmplDataStr.append(s.name());
                        if (pos < p.setList().size() - 1) {
                            this._cmplDataStr.append(",");
                        }
                        ++pos;
                    }
                    this._cmplDataStr.append("] <\n");
                    this._cmplDataStr.append((CharSequence)this.writeListElements(p.values()));
                    this._cmplDataStr.append(">\n");
                    continue;
                }
                this._cmplDataStr.append(" < ");
                this._cmplDataStr.append((CharSequence)this.writeElement(p.value()));
                this._cmplDataStr.append(" >\n");
            }
            if (!this._remoteMode) {
                BufferedWriter out = new BufferedWriter(new FileWriter(this._cmplDataFile));
                out.write(this._cmplDataStr.toString());
                out.close();
            }
        }
        catch (Exception e) {
            throw new CmplException("Internal error in " + this.getClass().getName() + "\n " + e);
        }
    }

    private StringBuilder writeElement(Object val) throws CmplException {
        if (val == null) {
            throw new CmplException("Parameter or set w/o value ");
        }
        StringBuilder tmpStr = new StringBuilder();
        if (val.getClass().toString().contains("String")) {
            tmpStr.append("\"");
            tmpStr.append(val);
            tmpStr.append("\" ");
        } else {
            tmpStr.append(val.toString());
            tmpStr.append(" ");
        }
        return tmpStr;
    }

    private StringBuilder writeListElements(Object val) throws CmplException {
        StringBuilder tmpStr = new StringBuilder();
        if (val instanceof int[]) {
            for (int i = 0; i < ((int[])val).length; ++i) {
                tmpStr.append((CharSequence)this.writeElement(((int[])val)[i]));
            }
        } else if (val instanceof long[]) {
            for (int i = 0; i < ((long[])val).length; ++i) {
                tmpStr.append((CharSequence)this.writeElement(((long[])val)[i]));
            }
        } else if (val instanceof float[]) {
            for (int i = 0; i < ((float[])val).length; ++i) {
                tmpStr.append((CharSequence)this.writeElement(Float.valueOf(((float[])val)[i])));
            }
        } else if (val instanceof double[]) {
            for (int i = 0; i < ((double[])val).length; ++i) {
                tmpStr.append((CharSequence)this.writeElement(((double[])val)[i]));
            }
        } else if (val.getClass().toString().contains("List") || val.getClass().isArray()) {
            if (val.getClass().toString().contains("List")) {
                for (int i = 0; i < ((ArrayList)val).size(); ++i) {
                    if (((ArrayList)val).get(i).getClass().toString().contains("List") || ((ArrayList)val).get(i).getClass().isArray()) {
                        tmpStr.append((CharSequence)this.writeListElements(((ArrayList)val).get(i)));
                        continue;
                    }
                    tmpStr.append((CharSequence)this.writeElement(((ArrayList)val).get(i)));
                }
            } else if (val.getClass().isArray()) {
                for (int i = 0; i < ((Object[])val).length; ++i) {
                    if (((Object[])val)[i].getClass().toString().contains("List") || ((Object[])val)[i].getClass().isArray()) {
                        tmpStr.append((CharSequence)this.writeListElements(((Object[])val)[i]));
                        continue;
                    }
                    tmpStr.append((CharSequence)this.writeElement(((Object[])val)[i]));
                }
            }
        } else {
            tmpStr.append((CharSequence)this.writeElement(val));
        }
        tmpStr.append("\n");
        return tmpStr;
    }

    private void getSolver() throws CmplException {
        boolean solverFound = false;
        for (String o : this._optionsList.values()) {
            if (!o.contains("-solver")) continue;
            this._solver = this._compatibility > 2 ? o.split("\\s")[1].replace("\"", "") : o.split("\\s")[2].replace("\"", "");
            solverFound = true;
            break;
        }
        if (!solverFound) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(this._model));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (!line.trim().startsWith("%arg") || !line.contains("-solver")) continue;
                    this._solver = line.split("\\s")[2].replace("\"", "");
                }
            }
            catch (IOException e) {
                throw new CmplException("Cannot read Cmpl file <" + this._model + "> " + e);
            }
        }
    }

    private Object getElementByName(String name, ArrayList<CmplSolElement> solObj) throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            CmplSolArray val = new CmplSolArray();
            CmplSolElement val1 = null;
            boolean isArray = false;
            for (CmplSolElement e : solObj) {
                if (!e.name().startsWith(name)) continue;
                if (e.name().contains("[")) {
                    if (!e.name().substring(0, e.name().indexOf("[")).equals(name)) continue;
                    if (!isArray) {
                        isArray = true;
                    }
                    val.put(e.name().substring(e.name().indexOf("[") + 1, e.name().indexOf("]")), e);
                    continue;
                }
                if (!e.name().equals(name)) continue;
                val1 = e;
                break;
            }
            if (isArray) {
                return val;
            }
            return val1;
        }
        throw new CmplException("No solution found so far");
    }

    private void handleOutput(String oStr) {
        if (!oStr.isEmpty()) {
            if (this._printOutput) {
                if (!this._outputLeadString.isEmpty()) {
                    System.out.println(this._outputLeadString + oStr.trim().replace("\n", "\n" + this._outputLeadString));
                } else {
                    System.out.println(oStr.trim().replace("\n", "\n" + this._outputLeadString));
                }
            }
            this._outputString.append(oStr);
        }
    }

    private void connectServerViaScheduler(String cmplUrl) throws CmplException {
        this._cmplGridSchedulerUrl = this._cmplUrl;
        this._cmplUrl = cmplUrl;
        this._cmplGridScheduler = this._cmplServer;
        this._serverMode = 22;
        try {
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(this._cmplUrl));
            this._cmplServer = new XmlRpcClient();
            this._cmplServer.setConfig((XmlRpcClientConfig)config);
            this.handleOutput("Connected with CmplServer at " + this._cmplUrl + " with jobId " + this._jobId + " >> maxServerTries <" + this._maxCmplServerTries + "> maxQueuingTime <" + this._maxCmplServerQueuingTime + ">");
        }
        catch (Exception e) {
            this._remoteStatus = 7;
            throw new CmplException(e.toString());
        }
    }

    private void knockScheduler() throws CmplException {
        Object[] ret = null;
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplScheduler");
            }
            if (this._remoteStatus != 13) {
                ret = this.cmplServerExecute("knock", new Object[]{this._jobId});
                this._remoteStatus = (Integer)ret[0];
                if (this._remoteStatus == 17) {
                    this.cleanUp();
                    throw new CmplException(ret[1].toString());
                }
                if (this._remoteStatus == 16) {
                    this.connectServerViaScheduler((String)ret[1]);
                }
            }
        } else {
            throw new CmplException("Cmpl.knock can only be used in remote mode");
        }
    }

    private Object[] cmplServerExecute(String methodName, Object[] params) throws CmplException {
        Object[] ret = null;
        int tries = 0;
        while (true) {
            try {
                if (methodName.equals("cmplServerFailed")) {
                    ret = (Object[])this._cmplGridScheduler.execute(methodName, params);
                    break;
                }
                ret = (Object[])this._cmplServer.execute(methodName, params);
            }
            catch (Exception e) {
                if (++tries != this._maxCmplServerTries) continue;
                this._remoteStatus = 7;
                this.cleanUp();
                throw new CmplException("CmplServer error : " + e.toString());
            }
            break;
        }
        return ret;
    }

    private void writeSolFiles() throws CmplException {
        Object fName;
        this.handleOutput("\n");
        if (!this.cmplSolFile().isEmpty()) {
            fName = this.cmplSolFile().equals("cmplStandard") ? this._problem + ".csol" : this.cmplSolFile();
            this.saveSolution((String)fName);
        }
        if (!this.asciiSolFile().isEmpty()) {
            fName = this.asciiSolFile().equals("cmplStandard") ? this._problem + ".sol" : this.asciiSolFile();
            this.saveSolutionAscii((String)fName);
        }
        if (!this.csvSolFile().isEmpty()) {
            fName = this.csvSolFile().equals("cmplStandard") ? this._problem + ".csv" : this.csvSolFile();
            this.saveSolutionCsv((String)fName);
        }
    }
}

