/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplMsg;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

class CmplMessages {
    private String _cmplStatus;
    private String _cmplVersion;
    private String _cmplMessage;
    private String _msgFile;
    private ArrayList<CmplMsg> _cmplMessageList;

    private void setDefaults() {
        this._cmplStatus = "";
        this._cmplVersion = "";
        this._cmplMessage = "";
        this._msgFile = "";
        this._cmplMessageList = new ArrayList();
    }

    public CmplMessages() {
        this.setDefaults();
    }

    public CmplMessages(String msgFile) {
        this.setDefaults();
        this._msgFile = msgFile;
    }

    public int cmplStatus() {
        int stat = -99;
        stat = this._cmplStatus.equalsIgnoreCase("normal") ? 1 : (this._cmplStatus.equalsIgnoreCase("warning") ? 2 : (this._cmplStatus.equalsIgnoreCase("error") ? 3 : 0));
        return stat;
    }

    public ArrayList<CmplMsg> cmplMessageList() {
        return this._cmplMessageList;
    }

    protected void readCmplMessages() throws CmplException {
        this.readCmplMessages("");
    }

    protected void readCmplMessages(String msgStr) throws CmplException {
        if (msgStr.isEmpty() && this._msgFile.isEmpty()) {
            throw new CmplException("Neither cmplMessageFile nor cmplMessageString defined");
        }
        ArrayList<String> lines = null;
        if (!this._msgFile.isEmpty()) {
            String line = "";
            try {
                BufferedReader in = new BufferedReader(new FileReader(this._msgFile));
                lines = new ArrayList();
                while ((line = in.readLine()) != null) {
                    lines.add(line);
                }
                in.close();
            }
            catch (IOException err) {
                throw new CmplException("Cannot read message file :" + this._msgFile + " ->" + err);
            }
        } else {
            lines = new ArrayList<String>(Arrays.asList(msgStr.split("\n")));
        }
        int lineNr = 1;
        Boolean generalSection = false;
        Boolean msgSection = false;
        for (String line : lines) {
            if (lineNr == 1) {
                if (line.contains("<?xml version")) {
                    ++lineNr;
                    continue;
                }
                throw new CmplException("Cant't read cmplMessage file  - Not a XML file !");
            }
            if (lineNr == 2) {
                if (line.contains("<CmplMessages")) {
                    ++lineNr;
                    continue;
                }
                throw new CmplException("Cant't read cmplMessage file  - Not a CmplMessages file !");
            }
            if (line.contains("<general>")) {
                generalSection = true;
                msgSection = false;
                continue;
            }
            if (line.contains("</general>")) {
                generalSection = false;
                continue;
            }
            if (line.contains("<messages")) {
                generalSection = false;
                msgSection = true;
                continue;
            }
            if (line.contains("</messages")) {
                msgSection = false;
                continue;
            }
            if (generalSection.booleanValue()) {
                if (line.contains("<generalStatus")) {
                    this._cmplStatus = CmplTools.xmlStrToString(line, "<generalStatus>([^\"]*)</generalStatus>");
                    continue;
                }
                if (line.contains("<message")) {
                    this._cmplMessage = CmplTools.xmlStrToString(line, "<message>([^\"]*)</message>");
                    continue;
                }
                if (line.contains("<cmplVersion")) {
                    this._cmplVersion = CmplTools.xmlStrToString(line, "<cmplVersion>([^\"]*)</cmplVersion>");
                    continue;
                }
            }
            if (!msgSection.booleanValue() || !line.contains("<message")) continue;
            ArrayList<String> tmpList = new ArrayList<String>();
            String patternStr = "\"([^\"]*)\"";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(line);
            while (matcher.find()) {
                tmpList.add(matcher.group(1));
            }
            CmplMsg x = new CmplMsg();
            x.setType((String)tmpList.get(0));
            x.setFile((String)tmpList.get(1));
            x.setLine((String)tmpList.get(2));
            x.setDesrciption(StringEscapeUtils.unescapeXml((String)((String)tmpList.get(3))));
            this._cmplMessageList.add(x);
        }
    }
}

