/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplSet;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmplParameter {
    private String _name;
    private Object _valueList;
    private ArrayList<CmplSet> _setList;
    private long _count;
    private int _rank;
    private int _valType;

    private void setDefaults(String name) throws CmplException {
        this._count = 1L;
        this._rank = 0;
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            throw new CmplException("parameter name " + this._name + " contains whitespaces");
        }
        this._name = name;
        this._rank = 0;
        this._setList = new ArrayList();
    }

    public CmplParameter(String name) throws CmplException {
        this.setDefaults(name);
    }

    public CmplParameter(String name, CmplSet ... sets) throws CmplException {
        this.setDefaults(name);
        for (CmplSet set : sets) {
            this._setList.add(set);
            this._rank += set.rank();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long countElements(Object val) throws CmplException {
        long _tmpcount = 0L;
        if (val.getClass().toString().contains("List")) {
            _tmpcount = ((ArrayList)val).size();
            if (!((ArrayList)val).get(0).getClass().toString().contains("List") && !((ArrayList)val).get(0).getClass().isArray()) return _tmpcount;
            _tmpcount *= this.countElements(((ArrayList)val).get(0));
            return _tmpcount;
        } else {
            if (!val.getClass().isArray()) return 1L;
            if (val instanceof int[]) {
                _tmpcount = ((int[])val).length;
                _tmpcount *= this.countElements(((int[])val)[0]);
                return _tmpcount;
            } else if (val instanceof long[]) {
                _tmpcount = ((long[])val).length;
                _tmpcount *= this.countElements(((long[])val)[0]);
                return _tmpcount;
            } else if (val instanceof float[]) {
                _tmpcount = ((float[])val).length;
                _tmpcount *= this.countElements(Float.valueOf(((float[])val)[0]));
                return _tmpcount;
            } else if (val instanceof double[]) {
                _tmpcount = ((double[])val).length;
                _tmpcount *= this.countElements(((double[])val)[0]);
                return _tmpcount;
            } else {
                if (!(val instanceof Object[])) throw new CmplException("parameter name " + this._name + " containts data with unsupported data type" + val.getClass().toString());
                _tmpcount = ((Object[])val).length;
                _tmpcount *= this.countElements(((Object[])val)[0]);
            }
        }
        return _tmpcount;
    }

    private void setScalarParam(Object val) throws CmplException {
        if (this._rank > 0) {
            throw new CmplException("incompatible data for a parameter array : " + val.toString());
        }
        this._valueList = val;
        this._valType = 3;
    }

    public void setValues(Integer val) throws CmplException {
        this.setScalarParam(val);
    }

    public void setValues(Long val) throws CmplException {
        this.setScalarParam(val);
    }

    public void setValues(Float val) throws CmplException {
        this.setScalarParam(val);
    }

    public void setValues(Double val) throws CmplException {
        this.setScalarParam(val);
    }

    public void setValues(String val) throws CmplException {
        this.setScalarParam(val);
    }

    public void setValues(Object val) throws CmplException {
        if (!val.getClass().toString().contains("List") && !val.getClass().isArray()) {
            throw new CmplException("Incompatible data - not a list or an array - for parameter :" + this._name);
        }
        if (this._rank == 0) {
            throw new CmplException("incompatible data for a scalar parameter : " + val.toString());
        }
        this._valueList = val;
        if (val.getClass().toString().contains("List")) {
            this._valType = 1;
        } else if (val.getClass().isArray()) {
            this._valType = 2;
        }
        long sCount = 1L;
        for (int i = 0; i < this._setList.size(); ++i) {
            sCount *= (long)this._setList.get(i).len();
        }
        this._count = this.countElements(this._valueList);
        if (this._count != sCount) {
            throw new CmplException("The dimension of the paramter " + this._name + " doesn't match the dimension of the set(s).");
        }
    }

    public List<CmplSet> setList() {
        return this._setList;
    }

    public Object values() {
        return this._valueList;
    }

    public Object value() {
        return this._valueList;
    }

    public String name() {
        return this._name;
    }

    public int rank() {
        return this._rank;
    }

    public long len() {
        return this._count;
    }

    public int valType() {
        return this._valType;
    }
}

